function [HR, HRS, HlR, HlRS, HiR, HiRS, ChiR, HshR, HshRS] = xtrploop(R, pars)

%XTRPLOOP Loops over iterations of the extrapolation procedure.
%
% USAGE
%   [HR, HRS, HLR, HLRS, HIR, HIRS, CHIR, HSHR, HSHRS] = XTRPLOOP(R, PARS)

%   Copyright (C) 2010 Cesare Magri
%   Version: 1.0.0

% -------
% LICENSE
% -------
% This software is distributed free under the condition that:
%
% 1. it shall not be incorporated in software that is subsequently sold;
%
% 2. the authorship of the software shall be acknowledged and the following
%    article shall be properly cited in any publication that uses results
%    generated by the software:
%
%      Magri C, Whittingstall K, Singh V, Logothetis NK, Panzeri S: A
%      toolbox for the fast information analysis of multiple-site LFP, EEG
%      and spike train recordings. BMC Neuroscience 2009 10(1):81;
%
% 3.  this notice shall remain in place in each source file.

% ----------
% DISCLAIMER
% ----------
% THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
% IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
% THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
% PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
% CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
% EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
% PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
% PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
% LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
% NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
% SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

% Try to make the XTRP=1 case as fast as possible:
if pars.xtrp==1
    [HR, HRS, HlR, HlRS, HiR, HiRS, ChiR, HshR, HshRS] = ...
            quadratic_extrapolation_v2(R, pars);
        
else
    HR    = 0;
    HRS   = 0; 
    HlR   = 0;
    HlRS  = 0;
    HiR   = 0;
    HiRS  = 0;
    ChiR  = 0;
    HshR  = 0;
    HshRS = 0;

    for k=1:pars.xtrp
        [HRtmp, HRStmp, HlRtmp, HlRStmp, HiRtmp, HiRStmp, ChiRtmp, HshRtmp, HshRStmp] = ...
            quadratic_extrapolation_v2(R, pars);

        HR    = HR    + HRtmp    ./ pars.xtrp; 
        HRS   = HRS   + HRStmp   ./ pars.xtrp;
        HlR   = HlR   + HlRtmp   ./ pars.xtrp;
        HlRS  = HlRS  + HlRStmp  ./ pars.xtrp;
        HiR   = HiR   + HiRtmp   ./ pars.xtrp;
        HiRS  = HiRS  + HiRStmp  ./ pars.xtrp;
        ChiR  = ChiR  + ChiRtmp  ./ pars.xtrp;
        HshR  = HshR  + HshRtmp  ./ pars.xtrp;
        HshRS = HshRS + HshRStmp ./ pars.xtrp;
    end
end